/*
USE [master]
GO
DROP PROCEDURE [dbo].[WriteResultsToCsvFile]
DROP PROCEDURE [dbo].[WriteResultsToTabFile]
DROP ASSEMBLY [SQLCLRNet_BCPReplacement]
DROP USER SQLCLRNet_ExampleLogin
DROP LOGIN SQLCLRNet_ExampleLogin 
DROP ASYMMETRIC KEY SQLCLRNet_ExampleKey
GO
*/

USE [master]
GO
IF OBJECT_ID('[dbo].[WriteResultsToCsvFile]') IS NOT NULL
BEGIN
	DROP PROCEDURE [dbo].[WriteResultsToCsvFile]
END
GO

IF OBJECT_ID('[dbo].[WriteResultsToTabFile]') IS NOT NULL
BEGIN
	DROP PROCEDURE [dbo].[WriteResultsToTabFile]
END
GO

IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N'SQLCLRNet_BCPReplacement')
DROP ASSEMBLY [SQLCLRNet_BCPReplacement]

GO

CREATE ASSEMBLY [SQLCLRNet_BCPReplacement]
AUTHORIZATION [dbo]
FROM 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
WITH PERMISSION_SET = SAFE

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'DelimitedFileWriter.vb'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'My Project\AssemblyInfo.vb'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 0x4D6963726F736F667420432F432B2B204D534620372E30300D0A1A445300000000020000020000002B000000D40000000000000028000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000C0FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3800000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0BCA3101380000000010000000100000000000001200FFFF04000000038000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000942E310104539249010000003BAB0860999520438FED118D0726481C000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000BCA310138000000001000000010000000000000FFFFFFFF040000000380000000000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000B8D0123A6CC2D011B44200A0244A1DD2C4454B99E9E6D211903F00C04FA302A10B9D865A1166D311BD2A0000F80849BD60A66E40CF64824CB6F042D48172A7991000000000000000FE10A9CD41A6B4BD1C07DB7A291D807500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000B8D0123A6CC2D011B44200A0244A1DD2C4454B99E9E6D211903F00C04FA302A10B9D865A1166D311BD2A0000F80849BD60A66E40CF64824CB6F042D48172A7991000000000000000FEA2AA07A092D3131A073FB82AF6976700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000B8D0123A6CC2D011B44200A0244A1DD2C4454B99E9E6D211903F00C04FA302A10B9D865A1166D311BD2A0000F80849BD60A66E40CF64824CB6F042D48172A7991000000000000000181C9FD3EC080EEC0AA55C023B6E751800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000B8D0123A6CC2D011B44200A0244A1DD2C4454B99E9E6D211903F00C04FA302A10B9D865A1166D311BD2A0000F80849BD60A66E40CF64824CB6F042D48172A799100000000000000048616B7A736F4C596055563F5CC9714700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000B8D0123A6CC2D011B44200A0244A1DD2C4454B99E9E6D211903F00C04FA302A10B9D865A1166D311BD2A0000F80849BD60A66E40CF64824CB6F042D48172A799100000000000000059141C23E5AEE3C6E9DE1F0D528ADB000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005E040000000000005E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEEFFEEF01000000EB0400000031376431346635632D613333372D343937382D383238312D353334393333373863313037312E76620000433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C44656C696D6974656446696C655772697465722E766200633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C64656C696D6974656466696C657772697465722E766200433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C4D792050726F6A6563745C417373656D626C79496E666F2E766200633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C6D792070726F6A6563745C617373656D626C79696E666F2E766200433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C5772697465526573756C7473546F43737646696C652E766200633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C7772697465726573756C7473746F63737666696C652E766200433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C5772697465526573756C7473546F54616246696C652E766200633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C7772697465726573756C7473746F74616266696C652E76620011000000000000000000000000000000C10000002A00000057010000F10100002B0000008B020000230300000000000000000000BB030000530400000000000001000000000000000A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001BE230013001000092588BA5008CC901010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050000000A000000010000009A0100000000000001000000280000001BE23001F3AA9CDE58000000010000002A0000000100000065000000000000000000000023030000280000001BE230013E3EA54E580000008B0200002A00000023030000650000000000000000000000C1000000280000001BE23001FE026A62580000002B0000002A000000C100000065000000000000000000000053040000280000001BE23001B48DB68758000000BB0300002A00000053040000650000000000000000000000F1010000280000001BE2300110F1865F58000000570100002A000000F1010000650000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400000036002A1100000000D403000000000000350000000000000000000000020000060000000001000000005772697465546F537472696E6700001600031104000000D00300003500000000000000010000001E00241140463A53797374656D2E446174612E53716C436C69656E74000000001200241140463A53797374656D2E4461746100001200241140463A53797374656D2E494F000000001200241140463A53797374656D2E5465787400002200241140463A53797374656D2E436F6C6C656374696F6E732E47656E657269630000000E00241140463A53797374656D0000001E0024112A53514C434C524E65745F4243505265706C6163656D656E74000000320024114050583A786D6C3D687474703A2F2F7777772E77332E6F72672F584D4C2F313939382F6E616D657370616365000000002A0024114050583A786D6C6E733D687474703A2F2F7777772E77332E6F72672F323030302F786D6C6E732F000E00241140503A53797374656D0000001A00241140503A53797374656D2E436F6C6C656374696F6E730000001E00241140503A4D6963726F736F66742E56697375616C42617369630000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E7374616E74730000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E76657273696F6E00000026002411234D6963726F736F66742E56697375616C42617369632E44617465416E6454696D65000026002411234D6963726F736F66742E56697375616C42617369632E46696C6553797374656D00000026002411234D6963726F736F66742E56697375616C42617369632E46696E616E6369616C0000000022002411234D6963726F736F66742E56697375616C42617369632E476C6F62616C73000026002411234D6963726F736F66742E56697375616C42617369632E496E666F726D6174696F6E000026002411234D6963726F736F66742E56697375616C42617369632E496E746572616374696F6E000022002411234D6963726F736F66742E56697375616C42617369632E56424D61746800000022002411234D6963726F736F66742E56697375616C42617369632E537472696E677300001A00241140503A53797374656D2E446961676E6F73746963730000001200241140503A53797374656D2E4461746100000A0024114050583A3D0000001E00241153514C434C524E65745F4243505265706C6163656D656E74000000001A00201100000000010000110000000000000000777269746572000022002011010000000100001100000000000000005772697465546F537472696E6700000002000600020006003E002A1100000000A8040000000000004B000000000000000000000003000006350000000100000000577269746548656164657273546F53747265616D00000016000311D8030000A40400004B00000035000000010000000E0024112831303036363332393800000E0024114031303036363332393800001E00201101000000020000110000000000000400564224745F6934244C3000001600031118040000A00400003200000043000000010000001600201100000000020000110000000000000000690000000200060002000600020006003A002A11000000007805000000000000500000000000000000000000040000068000000001000000005772697465526F77546F53747265616D00000016000311AC040000740500005000000080000000010000000E0024112831303036363332393800000E0024114031303036363332393800001E00201101000000030000110000000000000400564224745F6934244C30000016000311E804000070050000370000008E0000000100000016002011000000000300001100000000000000006900000002000600020006000200060032002A1100000000040600000000000082000000000000000000000005000006D0000000010000000057726974654974656D0000160003117C0500000006000082000000D0000000010000000E0024112831303036363332393800000E0024114031303036363332393800001600201100000000040000110000000000000000730000000200060002000600F20000009C000000000000000100010035000000000000000B00000090000000000000000C000080010000000D000080070000000E0000800A0000000F000080140000001000008015000000EEEFFE801700000012000080210000001300008022000000110000802A00000014000080330000001500008005009D000D002900090017000D00420009000F00010002000D003E0009001200090018000900210005001100F20000009C00000035000000010001004B000000000000000B00000090000000000000001700008001000000180000800E000000190000801D0000001A000080280000001B000080320000001C000080330000001D0000803F0000001E000080400000001F00008045000000EEEFFE80490000002000008005009800090032000D0037000D002A00110028000D00110011002A000D00130009000D000100020005000C00F20000009C000000800000000100010050000000000000000B00000090000000000000002200008001000000230000800E0000002400008022000000250000802D00000026000080370000002700008038000000280000804400000029000080450000002A0000804A000000EEEFFE804E0000002B00008005009400090032000D0043000D002A00110028000D00110011002A000D00130009000D000100020005000C00F20000009C000000D00000000100010082000000000000000B00000090000000000000002D000080010000002E000080040000002F000080070000003000008008000000310000800F000000330000804E00000034000080760000003500008077000000360000807F00000037000080800000003800008005006E00090020000D00150009000F000D002A0009009C000D00400009000D000D001C0009000F0005000C00F4000000080000002B0000000000000020000000000000001C00000034000000580000007000000090000000A8000000C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000003E002A11000000006805000000000000860100000000000000000000070000065201000001000000005772697465526573756C7473546F43737646696C6500001600031104000000640500008601000052010000010000000E0024112831303036363332393800001200241140463A53797374656D2E5465787400001200241140463A53797374656D2E494F000000002200241140463A4D6963726F736F66742E53716C5365727665722E5365727665720000001A00241140463A53797374656D2E446174612E53716C5479706573001E00241140463A53797374656D2E446174612E53716C436C69656E74000000001200241140463A53797374656D2E4461746100000E00241140463A53797374656D0000001E0024112A53514C434C524E65745F4243505265706C6163656D656E74000000320024114050583A786D6C3D687474703A2F2F7777772E77332E6F72672F584D4C2F313939382F6E616D657370616365000000002A0024114050583A786D6C6E733D687474703A2F2F7777772E77332E6F72672F323030302F786D6C6E732F000E00241140503A53797374656D0000001A00241140503A53797374656D2E436F6C6C656374696F6E730000001E00241140503A4D6963726F736F66742E56697375616C42617369630000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E7374616E74730000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E76657273696F6E00000026002411234D6963726F736F66742E56697375616C42617369632E44617465416E6454696D65000026002411234D6963726F736F66742E56697375616C42617369632E46696C6553797374656D00000026002411234D6963726F736F66742E56697375616C42617369632E46696E616E6369616C0000000022002411234D6963726F736F66742E56697375616C42617369632E476C6F62616C73000026002411234D6963726F736F66742E56697375616C42617369632E496E666F726D6174696F6E000026002411234D6963726F736F66742E56697375616C42617369632E496E746572616374696F6E000022002411234D6963726F736F66742E56697375616C42617369632E56424D61746800000022002411234D6963726F736F66742E56697375616C42617369632E537472696E677300001A00241140503A53797374656D2E446961676E6F73746963730000001200241140503A53797374656D2E4461746100000A0024114050583A3D0000001E00241153514C434C524E65745F4243505265706C6163656D656E74000000001A002011000000000500001100000000000000006572726F720000001E00201101000000050000110000000000000000726F77636F756E74000000002200201108000000050000110000000000000400564224745F61727261792453300000001600031144000000F8040000CA00000062010000010000001A00201102000000050000110000000000000000636F6E6E000000001600031124040000F4040000AE0000006F010000010000001600201103000000050000110000000000000000636D64001600031158040000F00400008E00000080010000010000001600201104000000050000110000000000000000647200001600031188040000EC040000730000008A010000010000001A0020110500000005000011000000000000000073747265616D00000200060002000600020006000200060016000311440000002C050000030000003A0200000100000016002011060000000500001100000000000000006578000002000600160003114400000060050000840000004F020000010000001600201107000000050000110000000000000000736472000200060002000600020006003E002A1100000000D00A00000000000086010000000000000000000008000006D802000001000000005772697465526573756C7473546F54616246696C650000160003116C050000CC0A000086010000D8020000010000000E0024112831303036363332393800001200241140463A53797374656D2E5465787400001200241140463A53797374656D2E494F000000002200241140463A4D6963726F736F66742E53716C5365727665722E5365727665720000001A00241140463A53797374656D2E446174612E53716C5479706573001E00241140463A53797374656D2E446174612E53716C436C69656E74000000001200241140463A53797374656D2E4461746100000E00241140463A53797374656D0000001E0024112A53514C434C524E65745F4243505265706C6163656D656E74000000320024114050583A786D6C3D687474703A2F2F7777772E77332E6F72672F584D4C2F313939382F6E616D657370616365000000002A0024114050583A786D6C6E733D687474703A2F2F7777772E77332E6F72672F323030302F786D6C6E732F000E00241140503A53797374656D0000001A00241140503A53797374656D2E436F6C6C656374696F6E730000001E00241140503A4D6963726F736F66742E56697375616C42617369630000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E7374616E74730000000026002411234D6963726F736F66742E56697375616C42617369632E436F6E76657273696F6E00000026002411234D6963726F736F66742E56697375616C42617369632E44617465416E6454696D65000026002411234D6963726F736F66742E56697375616C42617369632E46696C6553797374656D00000026002411234D6963726F736F66742E56697375616C42617369632E46696E616E6369616C0000000022002411234D6963726F736F66742E56697375616C42617369632E476C6F62616C73000026002411234D6963726F736F66742E56697375616C42617369632E496E666F726D6174696F6E000026002411234D6963726F736F66742E56697375616C42617369632E496E746572616374696F6E000022002411234D6963726F736F66742E56697375616C42617369632E56424D61746800000022002411234D6963726F736F66742E56697375616C42617369632E537472696E677300001A00241140503A53797374656D2E446961676E6F73746963730000001200241140503A53797374656D2E4461746100000A0024114050583A3D0000001E00241153514C434C524E65745F4243505265706C6163656D656E74000000001A002011000000000600001100000000000000006572726F720000001E00201101000000060000110000000000000000726F77636F756E74000000002200201108000000060000110000000000000400564224745F617272617924533000000016000311AC050000600A0000CA000000E8020000010000001A00201102000000060000110000000000000000636F6E6E00000000160003118C0900005C0A0000AE000000F5020000010000001600201103000000060000110000000000000000636D640016000311C0090000580A00008E000000060300000100000016002011040000000600001100000000000000006472000016000311F0090000540A00007300000010030000010000001A0020110500000006000011000000000000000073747265616D00000200060002000600020006000200060016000311AC050000940A000003000000C0030000010000001600201106000000060000110000000000000000657800000200060016000311AC050000C80A000084000000D503000001000000160020110700000006000011000000000000000073647200020006000200060002000600F200000070020000520100000100010086010000000000003200000064020000000000000C000080010000000E00008003000000100000800E000000120000800F0000001400008010000000140000801B000000EEEFFE801C000000160000801D0000001600008025000000EEEFFE8026000000180000802D0000001B0000802E0000001B00008036000000EEEFFE80370000001D000080380000001D00008046000000EEEFFE80470000001F0000804A000000200000805A000000210000805B000000EEEFFE805D000000240000806100000025000080710000002600008072000000230000807B0000002800008083000000290000808A0000002C000080920000002D0000809A0000002E0000809B000000EEEFFE80AB0000002F000080AC000000EEEFFE80BC00000030000080BD000000EEEFFE80CB00000031000080CC000000EEEFFE80E700000032000080E800000034000080F500000036000080F600000038000080FD000000390000804C0100003B0000805B0100003C000080650100003D000080740100003E000080810100003F00008082010000EEEFFE80830100004000008084010000410000800500BA000D0024000D002D0009000C000D004800130048000100020011003A0017003A000100020015002000150044001B00440001000200190069001F006900010002001D003300210064001D0023000100020021002E00210060001D0026001D002C001D0027001D0029001D002B001D002B00190022000100020015001E000100020011001A00010002000D0016000100020009001E000D001900090010000D0022001500C70011002A0011002A001100310011002A000D001300010002000900100005000C00F200000070020000D80200000100010086010000080000003200000064020000000000000C000080010000000E00008003000000100000800E000000120000800F0000001400008010000000140000801B000000EEEFFE801C000000160000801D0000001600008025000000EEEFFE8026000000180000802D0000001B0000802E0000001B00008036000000EEEFFE80370000001D000080380000001D00008046000000EEEFFE80470000001F0000804A000000200000805A000000210000805B000000EEEFFE805D000000240000806100000025000080710000002600008072000000230000807B0000002800008083000000290000808A0000002C000080920000002D0000809A0000002E0000809B000000EEEFFE80AB0000002F000080AC000000EEEFFE80BC00000030000080BD000000EEEFFE80CB00000031000080CC000000EEEFFE80E700000032000080E800000034000080F500000036000080F600000038000080FD000000390000804C0100003B0000805B0100003C000080650100003D000080740100003E000080810100003F00008082010000EEEFFE80830100004000008084010000410000800500BA000D0024000D002D0009000C000D004800130048000100020011003A0017003A000100020015002000150044001B00440001000200190069001F006900010002001D003300210066001D0023000100020021002E00210062001D0026001D002C001D0027001D0029001D002B001D002B00190022000100020015001E000100020011001A00010002000D0016000100020009001E000D001900090010000D0022001500C70011002A0011002A001100310011002A000D001300010002000900100005000C00F4000000100000008B02000000000000BB0300000000000010000000D8000000FC000000140100003801000000000000000000000000000000000000FFFFFFFF1A092FF160000000340200001D00000001000000D900000001000000010000000100000015010000010000005900000001000000FD0000000100000091000000010000007100000001000000C10000000100000035000000010000003901000001000000A900000001000000010008000000000000000000000000000000000000200000000000000000040001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000400000000000000000000000000000001000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000C0000001800000024000000300000003C0000004800000054000000600000006C00000078000000840000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001A002511000000000400000001005772697465546F537472696E67001600291100000000040000000100303630303030303200002200251100000000D80300000100577269746548656164657273546F53747265616D00001600291100000000D80300000100303630303030303300001E00251100000000AC04000001005772697465526F77546F53747265616D00001600291100000000AC04000001003036303030303034000016002511000000007C050000010057726974654974656D0016002911000000007C05000001003036303030303035000022002511000000000400000002005772697465526573756C7473546F43737646696C650016002911000000000400000002003036303030303037000022002511000000006C05000002005772697465526573756C7473546F54616246696C650016002911000000006C050000020030363030303030380000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000FFFFFFFF1A092FF10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFF77093101010000000F000088100027C61100ED0BEC000000AC0000002C000000E0010000000000000000000016000000190000000000EEC00000000000000000FFFF000000000000FFFFFFFF00000000FFFF0000000000000000000000000D000806000000000000A00200000100000058292B0F000000000000000053514C434C524E65745F4243505265706C6163656D656E742E44656C696D6974656446696C6557726974657200334436443044414600000000000000FFFF000000000000FFFFFFFF00000000FFFF0000000000000000000000000E00D40A00000000000008050000020000004882270F000000000000000053514C434C524E65745F4243505265706C6163656D656E742E53746F72656450726F6365647572657300374345343531364600002DBA2EF10100060100000000350000000000000000000000000000000000000001000000350000004B000000000000000000000000000000000000000100000080000000500000000000000000000000000000000000000001000000D000000082000000000000000000000000000000000000000100000052010000860100000000000001000000000000000000000001000000D80200008601000000000000010000000000000000000000020002000D01000000000100FFFFFFFF000000005E0400000802000000000000FFFFFFFF00000000FFFFFFFF02000300000001000100020000000000960000002E010000433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C44656C696D6974656446696C655772697465722E766200433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C5772697465526573756C7473546F43737646696C652E766200433A5C446F63756D656E747320616E642053657474696E67735C6A6B656861796961735C4D7920446F63756D656E74735C56697375616C2053747564696F20323030385C50726F6A656374735C53514C434C524E65745F4243505265706C6163656D656E745C53514C434C524E65745F4243505265706C6163656D656E745C5772697465526573756C7473546F54616246696C652E7662000000FEEFFEEF010000000100000000010000000000000000000000FFFFFFFFFFFFFFFFFFFF0C00FFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000942E310104539249010000003BAB0860999520438FED118D0726481CE20200002F4C696E6B496E666F002F6E616D6573002F7372632F686561646572626C6F636B002F7372632F66696C65732F31376431346635632D613333372D343937382D383238312D353334393333373863313037312E7662002F7372632F66696C65732F633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C64656C696D6974656466696C657772697465722E7662002F7372632F66696C65732F633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C6D792070726F6A6563745C617373656D626C79696E666F2E7662002F7372632F66696C65732F633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C7772697465726573756C7473746F63737666696C652E7662002F7372632F66696C65732F633A5C646F63756D656E747320616E642073657474696E67735C6A6B656861796961735C6D7920646F63756D656E74735C76697375616C2073747564696F20323030385C70726F6A656374735C73716C636C726E65745F6263707265706C6163656D656E745C73716C636C726E65745F6263707265706C6163656D656E745C7772697465726573756C7473746F74616266696C652E766200080000000E00000001000000A21F0000000000003F0200000B0000000A000000050000000000000004000000F70000000900000011000000060000009C0100000A00000022000000070000005600000008000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000000180000005A0300003800000013040000000000004305000030010000580000005800000058000000580000005800000028000000CC080000F00F0000A40200002C00000050010000030000002500000026000000060000002200000023000000240000000D0000000E0000000F000000100000000700000008000000090000000A0000000B0000000C0000001100000012000000130000001400000015000000160000001700000018000000190000001A0000001B0000001C0000001D0000001E0000001F0000002100000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000270000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
AS N'SQLCLRNet_BCPReplacement.pdb'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'WriteResultsToCsvFile.vb'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'WriteResultsToTabFile.vb'

GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyProjectRoot', @value=N'C:\Documents and Settings\jkehayias\My Documents\Visual Studio 2008\Projects\SQLCLRNet_BCPReplacement\SQLCLRNet_BCPReplacement' , @level0type=N'ASSEMBLY',@level0name=N'SQLCLRNet_BCPReplacement'
GO


-- Create the Asymmetric Key from the Assembly
IF NOT EXISTS (SELECT 1 FROM sys.asymmetric_keys WHERE name = 'SQLCLRNet_ExampleKey')
BEGIN
	CREATE ASYMMETRIC KEY SQLCLRNet_ExampleKey 
	FROM ASSEMBLY [SQLCLRNet_BCPReplacement]
END
GO

-- Create the Login from the Asymmetric Key
IF NOT EXISTS (SELECT 1 FROM sys.server_principals WHERE name = 'SQLCLRNet_ExampleLogin')
BEGIN
	CREATE LOGIN SQLCLRNet_ExampleLogin 
	FROM ASYMMETRIC KEY SQLCLRNet_ExampleKey

	-- Grant the External Access Priviledge to the Login
	GRANT EXTERNAL ACCESS ASSEMBLY TO SQLCLRNet_ExampleLogin 
END
GO

-- Create the database user for Authorization on the Assembly if it doesn't exist already
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = 'SQLCLRNet_ExampleLogin')
BEGIN
	CREATE USER SQLCLRNet_ExampleLogin FOR LOGIN SQLCLRNet_ExampleLogin
END
GO

-- Set Authorization to the Database User
ALTER AUTHORIZATION ON ASSEMBLY::[SQLCLRNet_BCPReplacement] TO SQLCLRNet_ExampleLogin
GO

-- Set the Assembly for External Access
ALTER ASSEMBLY [SQLCLRNet_BCPReplacement] WITH PERMISSION_SET = EXTERNAL_ACCESS
GO

-- Create the TSQL Procedure that maps to the Assembly
CREATE PROCEDURE [dbo].[WriteResultsToCsvFile]
	@sqlcmd [nvarchar](4000),
	@filename [nvarchar](4000),
	@includeheaders [bit] = 1,
	@quoteall [bit] = 1,
	@provideoutput [bit] = 0
WITH EXECUTE AS CALLER
AS
EXTERNAL NAME [SQLCLRNet_BCPReplacement].[SQLCLRNet_BCPReplacement.StoredProcedures].[WriteResultsToCsvFile]
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFile', @value=N'WriteResultsToCsvFile.vb' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToCsvFile'
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFileLine', @value=12 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToCsvFile'
GO

-- Create the TSQL Procedure that maps to the Assembly
CREATE PROCEDURE [dbo].[WriteResultsToTabFile]
	@sqlcmd [nvarchar](4000),
	@filename [nvarchar](4000),
	@includeheaders [bit] = 1,
	@quoteall [bit] = 1,
	@provideoutput [bit] = 0
WITH EXECUTE AS CALLER
AS
EXTERNAL NAME [SQLCLRNet_BCPReplacement].[SQLCLRNet_BCPReplacement.StoredProcedures].[WriteResultsToTabFile]
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFile', @value=N'WriteResultsToTabFile.vb' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToTabFile'
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFileLine', @value=12 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToTabFile'
GO
